//
// XBlast Robot File
//
// Program XBLAST V2.6 or higher
// (C) by Oliver Vogel (e-mail: m.vogel@ndh.net)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2; or (at your option)
// any later version
//
// This program is distributed in the hope that it will be entertaining,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License along
// with this program; if not, write to the Free Software Foundation, Inc.
// 675 Mass Ave, Cambridge, MA 02139, USA.
//
//

//
// default value for angles (if not already defined)
//
#ifndef (leftLowerArmAngle)
  #declare leftLowerArmAngle  = <  -15,   0, -30>
#end
#ifndef (leftArmAngle)
  #declare leftArmAngle       = <   15,  10, -45>
#end
#ifndef (rightLowerArmAngle)
  #declare rightLowerArmAngle = <  -15,   0,  30>
#end
#ifndef (rightArmAngle)
  #declare rightArmAngle      = <   15, -10,  45>
#end

#ifndef (rightLowerLegAngle)
  #declare rightLowerLegAngle = < - 25,  0,  0>
#end
#ifndef (rightLegAngle)
  #declare rightLegAngle      = < + 15, 15,  0>
#end
#ifndef (leftLowerLegAngle)
  #declare leftLowerLegAngle  = < - 25,  0,  0>
#end
#ifndef (leftLegAngle)
  #declare leftLegAngle       = < + 15,-15,  0>
#end

#ifndef (rightFootAngle)
  #declare rightFootAngle     = <    0,  0,  0>
#end
#ifndef (leftFootAngle)
  #declare leftFootAngle      = <    0,  0,  0>
#end

#ifndef (headAngle)
  #declare headAngle          = <    0,  0,  0>
#end
#ifndef (bodyAngle)           
  #declare bodyAngle          = <    0,  0,  0>
#end

//
// first of all the textures
//
// Dull creates a large, soft highlight on the object's surface
#declare myDull = finish {ambient 0.2 specular 0.25 roughness 0.40}

// Shiny creates a small, tight highlig
#declare myShiny = finish {ambient 0.2 specular 0.75 roughness 0.0125}


#declare boneTexture = 
texture {
  pigment {color red 0.98 green 0.92 blue 0.84}
  finish {myDull}
}

//
// standard bone
//
#declare unitBone =
union {
  cylinder {<0,0,0>, <1,0,0>, 0.2}
  sphere {
    <0,0,0>, 1 
    scale <0.3,0.2,0.2> 
    translate -0.3*x 
    rotate y*60
  }
  sphere {
    <0,0,0>, 1 
    scale <0.3,0.2,0.2> 
    translate -0.3*x 
    rotate y*-60
  }
  sphere {
    <0,0,0>, 1 
    scale <0.3,0.2,0.2> 
    translate 0.3*x 
    rotate y*60
    translate x*1
  }
  sphere {
    <0,0,0>, 1 
    scale <0.3,0.2,0.2> 
    translate 0.3*x 
    rotate y*-60
    translate x*1
  }
}

//
// the head
//
#declare PlayerHead =
union {
  // skull and eyes
  difference {
    union {
      sphere {
        <0,0,0>, 1
        scale <0.8,0.65,0.9>
      }
      sphere {
        <0,0,0>, 1
        scale <0.5,0.65,0.4>
        rotate x*30
        translate <0.0,-0.1,-0.4>
      }
    }
    merge {
      sphere {
        <0,0,0>, 1
        scale <0.75,0.60,0.85>
      }
      cylinder {
        <0,0,0>, <0,0,-1.5>, 1
        scale <0.2,0.3,1>
        translate <-0.3,0,0>
      }
      cylinder {
        <0,0,0>, <0,0,-1.5>, 1
        scale <0.2,0.3,1>
        translate <0.3,0,0>
      }
      cylinder {
        <0,0,0>, <0,0.2,0.0>, 0.5
        translate <0.0,-0.5,-1.0>
      }
    }
  }
  // teeth
  intersection {
    sphere {
      <0,0,0>, 1
      scale <0.475,0.625,0.375>
      rotate x*30
      translate <0.0,-0.1,-0.4>
    }
    cylinder {
      <0,-0.01,0>, <0,0.21,0.0>, 0.5
      translate <0.0,-0.5,-1.0>
    }
    texture {
     boneTexture
     normal {gradient x scallop_wave scale 0.15}
    }
  }
  texture {boneTexture}
  translate <0, 0.2125,-0.275>
  rotate headAngle
  translate <0,-0.2125, 0.275>
}

//
// the body
//
#declare PlayerBody =
union {
#declare YP=-0.6
#while (YP<1.0)
  cone { 
    <0, 0.11,0>, 0.2
    <0,-0.11,0> 0.15
    translate <0.0,YP,0.3>
  }
  #declare YP=YP+0.2
#end
#declare YP=0.05
#declare WINKEL=20
#while (YP<0.7)
  #declare RIP=0.75-YP*0.5
  intersection {
    torus {
      RIP ,0.075
      sturm
      scale <0.8,1.0,0.6>
      translate <0,YP,0.3-RIP>
      rotate z*WINKEL
    }
    plane { x, 0.01}
  }
  intersection {
    torus {
      RIP ,0.075
      sturm
      scale <0.8,1.0,0.6>
      translate <0,YP,0.3-RIP>
      rotate -z*WINKEL
    }
    plane { -x, 0.01}
  }
  #declare YP=YP+0.2
  #declare WINKEL=WINKEL-5
#end
  object {
    unitBone
    scale 0.7
    translate <-0.35,-0.60,0>
  }
  texture {boneTexture}
}


#declare PlayerRightHand =
union {
  object {
    unitBone
    scale 0.2
    translate x*-0.125
    translate z*0.05
  }
  object {
    unitBone
    scale 0.25
    translate x*-0.425
    translate z*0.05
  }
  object {
    unitBone
    scale 0.2
    translate x*-0.125
    translate z*-0.05
  }
  object {
    unitBone
    scale 0.25
    translate x*-0.425
    translate z*-0.05
  }
  // thumb
  object {
    unitBone 
    translate x*-0.5
    scale 0.25
    rotate y*90
    rotate y*60
    rotate z*30
    translate <-0.10,-0.05,-0.15>
  }
  texture {boneTexture}
  rotate z*-15
}

#declare PlayerRightLowerArm =
union {
 object {
    PlayerRightHand
    translate <-0.525,0,0>
  }
  object {
    unitBone
    scale 0.35
    translate x*(-0.4+0.025)
  }
}

#declare PlayerRightUpperArm =
union {
  object {
    PlayerRightLowerArm
    rotate rightLowerArmAngle
    translate x*-0.4
  }
  object {
    unitBone
    scale 0.35
    translate x*(-0.4+0.025)
  }
}

#declare PlayerRightArm =
union {
  object {
    PlayerRightUpperArm
    rotate rightArmAngle
  }
  object {
    unitBone
    scale 0.5
    translate x*0.1
  }
  texture {boneTexture}
}

//
// Left arm of player, includings hands
//

#declare PlayerLeftHand =
union {
  object {
    unitBone
    rotate y*180
    scale 0.2
    translate x*0.125
    translate z*0.05
  }
  object {
    unitBone
    rotate y*180
    scale 0.25
    translate x*0.425
    translate z*0.05
  }
  object {
    unitBone
    rotate y*180
    scale 0.2
    translate x*0.125
    translate z*-0.05
  }
  object {
    unitBone
    rotate y*180
    scale 0.25
    translate x*0.425
    translate z*-0.05
  }
  // thumb
  object {
    unitBone 
    rotate y*180
    translate x*0.5
    scale 0.25
    rotate y*-90
    rotate y*-60
    rotate z*-30
    translate <0.10,-0.05,-0.15>
  }
  texture {boneTexture}
  rotate z*15
}

#declare PlayerLeftLowerArm =
union {
  object {
    PlayerLeftHand
    translate <0.525,0,0>
  }
  object {
    unitBone
    scale 0.35
    translate x*0.025
  }
}

#declare PlayerLeftUpperArm =
union {
  object {
    PlayerLeftLowerArm
    rotate leftLowerArmAngle
    translate x*0.4
  }
  object {
    unitBone
    scale 0.35
    translate x*-0.025
  }
}

#declare PlayerLeftArm =
union {
  object {
    PlayerLeftUpperArm
    rotate leftArmAngle
  }
  object {
    unitBone
    scale 0.5
    translate x*-0.6
  }
  texture {boneTexture}
}

//
// legs
//

#declare PlayerFoot =
union {
  object {
    unitBone
    scale 0.4
    rotate y*100
    translate x*-0.05
  }
  object {
    unitBone
    scale 0.4
    rotate y*80
    translate x*0.05
  }
}

#declare PlayerLowerRightLeg =
union {
  object {
    PlayerFoot
    translate <0.0,-0.3,-0.1>
    rotate rightFootAngle
    translate <0.0,-0.4,0.0>
  }
  object {
    unitBone
    scale 0.35
    translate x*0.025
    rotate z*-90
  }
}

#declare PlayerUpperRightLeg =
union {
  object {
    PlayerLowerRightLeg
    rotate rightLowerLegAngle
    translate <0.0,-0.4,0.0>
  }
  object {
    unitBone
    scale 0.35
    translate x*0.025
    rotate z*-90
  }
}

#declare PlayerRightLeg =
object {
    PlayerUpperRightLeg
    rotate rightLegAngle
    texture {boneTexture}
}



#declare PlayerLowerLeftLeg =
union {
  object {
    PlayerFoot
    translate <0.0,-0.3,-0.1>
    rotate leftFootAngle
    translate <0.0,-0.4,0.0>
  }
  object {
    unitBone
    scale 0.35
    translate x*0.025
    rotate z*-90
  }
}

#declare PlayerUpperLeftLeg =
union {
  object {
    PlayerLowerLeftLeg
    rotate leftLowerLegAngle
    translate <0.0,-0.4,0.0>
  }
  object {
    unitBone
    scale 0.35
    translate x*0.025
    rotate z*-90
  }
}

#declare PlayerLeftLeg =
object {
  PlayerUpperLeftLeg
  rotate leftLegAngle
  texture {boneTexture}
}

//
// end file "XBlast Robot.inc"//
